/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.steps;

import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldDefinition;
import filenet.vw.api.VWParameterDefinition;
import filenet.vw.api.VWStepDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.steps.VWCaseParameterInfo;
import filenet.vw.toolkit.utils.IVWMouseActionListener;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWAddRemovePanel;
import filenet.vw.toolkit.utils.VWKeyAdapter;
import filenet.vw.toolkit.utils.VWMouseAdapter;
import filenet.vw.toolkit.utils.VWPopupMenu;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.images.VWImageLoader;
import filenet.vw.toolkit.utils.resources.VWResource;
import filenet.vw.toolkit.utils.table.VWLabelListCellRenderer;
import filenet.vw.toolkit.utils.table.VWSortedListModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

class VWCasePropertySelectionPanel
extends VWAddRemovePanel
implements ActionListener,
IVWMouseActionListener {
    private HashMap<String, VWCaseParameterInfo[]> m_availablePropertyMap;
    private HashMap<String, ArrayList<VWCaseParameterInfo>> m_selectedPropertyMap;
    private ArrayList<VWParameterDefinition> m_deletedStepParameters;
    private JComboBox m_guidFieldsCombo;
    private AbstractButton m_modeButton;
    private VWPopupMenu m_modePopupMenu;
    private JMenuItem m_readModeMenuItem;
    private JMenuItem m_readWriteModeMenuItem;
    private JMenuItem m_writeModeMenuItem;
    private VWAuthPropertyData m_authPropertyData;
    private VWStepDefinition m_stepDefinition;
    private VWFieldDefinition m_selectedFieldDefinition;

    public VWCasePropertySelectionPanel(Dialog parentDialog) {
        super(10);
        this.enableSorting(3840);
        this.setAvailableItemName(VWResource.s_availableProperties);
        this.setSelectedItemName(VWResource.s_selectedProperties);
        this.m_availablePropertyMap = new HashMap();
        this.m_deletedStepParameters = new ArrayList();
        this.initializeLists(null, null);
    }

    public void initialize(VWAuthPropertyData authPropertyData, VWStepDefinition stepDef) {
        this.m_authPropertyData = authPropertyData;
        this.m_stepDefinition = stepDef;
        this.m_guidFieldsCombo.setModel(this.getComboBoxModel());
        if (this.m_guidFieldsCombo.getModel().getSize() > 0) {
            this.m_guidFieldsCombo.setSelectedIndex(0);
        }
    }

    public void createParameters() throws VWException {
        for (int i = 0; i < this.m_deletedStepParameters.size(); ++i) {
            VWParameterDefinition paramDef = this.m_deletedStepParameters.get(i);
            if (paramDef == null) continue;
            this.m_stepDefinition.deleteParameter(paramDef.getName());
        }
        VWCaseParameterInfo.removePostAssignments(this.m_deletedStepParameters.toArray(new VWParameterDefinition[0]), this.m_stepDefinition);
        Set<String> fieldNameSet = this.m_selectedPropertyMap.keySet();
        Iterator<String> iter = fieldNameSet.iterator();
        while (iter.hasNext()) {
            ArrayList<VWParameterDefinition> paramDefList = new ArrayList<VWParameterDefinition>();
            String fieldName = iter.next();
            ArrayList<VWCaseParameterInfo> caseParamList = this.m_selectedPropertyMap.get(fieldName);
            for (int i = 0; i < caseParamList.size(); ++i) {
                VWCaseParameterInfo paramInfo = caseParamList.get(i);
                if (paramInfo == null) continue;
                paramDefList.add(paramInfo.createParameterDefinition(fieldName, this.m_stepDefinition, this.m_authPropertyData));
            }
            if (paramDefList.size() <= 0) continue;
            VWParameterDefinition[] parameterDefs = paramDefList.toArray(new VWParameterDefinition[0]);
            VWCaseParameterInfo.updatePostAssignments(fieldName, this.m_stepDefinition, this.m_authPropertyData, parameterDefs);
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            if (event.getSource().equals(this.m_guidFieldsCombo)) {
                this.m_selectedFieldDefinition = (VWFieldDefinition)this.m_guidFieldsCombo.getSelectedItem();
                Object[] availableProperties = this.m_availablePropertyMap.get(this.m_selectedFieldDefinition.getName());
                if (availableProperties == null) {
                    availableProperties = VWCaseParameterInfo.getSupportedProperties(this.m_selectedFieldDefinition);
                    this.m_availablePropertyMap.put(this.m_selectedFieldDefinition.getName(), (VWCaseParameterInfo[])availableProperties);
                }
                VWCaseParameterInfo[] selectedProperties = null;
                ArrayList<VWCaseParameterInfo> selectedList = this.m_selectedPropertyMap.get(this.m_selectedFieldDefinition.getName());
                if (selectedList != null) {
                    selectedProperties = selectedList.toArray(new VWCaseParameterInfo[0]);
                }
                this.initializeLists(availableProperties, selectedProperties);
            } else if (event.getSource().equals(this.m_modeButton) && this.m_modeButton.isEnabled()) {
                this.displayModePopup(this.m_modeButton, 10, 10);
            } else if (event.getSource().equals(this.m_readModeMenuItem)) {
                this.updateMode(1);
            } else if (event.getSource().equals(this.m_readWriteModeMenuItem)) {
                this.updateMode(3);
            } else if (event.getSource().equals(this.m_writeModeMenuItem)) {
                this.updateMode(2);
            } else {
                super.actionPerformed(event);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(JOptionPane.getFrameForComponent(this.m_parentContainer), ex.getLocalizedMessage(), 1);
        }
    }

    public void createPopup(MouseEvent event) {
        if (event.getSource().equals(this.m_selectedList)) {
            Object[] selectedItems = this.m_selectedList.getSelectedValues();
            if (selectedItems == null || selectedItems.length == 0) {
                return;
            }
            this.displayModePopup(event.getComponent(), event.getX(), event.getY());
        }
    }

    protected void addControls() {
        try {
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.0;
            gbCons.anchor = 23;
            gbCons.gridwidth = 0;
            gbCons.gridheight = 1;
            gbCons.insets = new Insets(3, 3, 3, 3);
            JPanel headerPanel = this.getHeaderPanel();
            if (headerPanel != null) {
                this.add((Component)headerPanel, gbCons);
            }
            ++gbCons.gridy;
            gbCons.fill = 1;
            gbCons.weightx = 0.5;
            gbCons.weighty = 1.0;
            gbCons.gridwidth = 1;
            this.add((Component)this.createAvailableListPanel(), gbCons);
            ++gbCons.gridx;
            gbCons.fill = 3;
            gbCons.weightx = 0.0;
            gbCons.anchor = 10;
            this.add((Component)this.createAddRemoveButtonPanel(), gbCons);
            ++gbCons.gridx;
            gbCons.fill = 1;
            gbCons.weightx = 0.5;
            gbCons.anchor = 23;
            this.add((Component)this.createSelectedListPanel(), gbCons);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected JPanel getHeaderPanel() {
        try {
            JPanel headerPanel = new JPanel(new BorderLayout(6, 6));
            JLabel label = new JLabel(VWResource.s_businessObject);
            headerPanel.add((Component)label, "Before");
            VWAccessibilityHelper.setAccessibility(label, this, label.getText(), label.getText());
            label.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_guidFieldsCombo = new JComboBox();
            headerPanel.add((Component)this.m_guidFieldsCombo, "Center");
            VWAccessibilityHelper.setAccessibility(this.m_guidFieldsCombo, headerPanel, label.getText(), label.getText());
            VWAccessibilityHelper.setLabelFor(label, this.m_guidFieldsCombo);
            this.m_guidFieldsCombo.setRenderer(new VWLabelListCellRenderer());
            this.m_guidFieldsCombo.addActionListener(this);
            return headerPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    protected JPanel createSelectedListPanel() {
        try {
            JPanel sListPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.0;
            gbCons.anchor = 21;
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            gbCons.insets = new Insets(0, 3, 0, 20);
            sListPanel.add((Component)this.m_selectedLabel, gbCons);
            VWAccessibilityHelper.setAccessibility(this.m_selectedLabel, this, this.m_selectedLabel.getText(), this.m_selectedLabel.getText());
            ++gbCons.gridx;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.insets = new Insets(0, 0, 0, 0);
            this.m_modeButton = VWImageLoader.createToolBarButton("popup.gif", VWResource.s_accessRights, false);
            this.m_modeButton.setEnabled(false);
            this.m_modeButton.addActionListener(this);
            sListPanel.add((Component)this.m_modeButton, gbCons);
            VWAccessibilityHelper.setAccessibility(this.m_modeButton, this, VWResource.s_accessRights, VWResource.s_accessRights);
            gbCons.gridx = 0;
            ++gbCons.gridy;
            gbCons.fill = 1;
            gbCons.weightx = 1.0;
            gbCons.weighty = 1.0;
            gbCons.gridwidth = 0;
            gbCons.insets = new Insets(0, 3, 0, 3);
            this.m_selectedList = new JList(new VWSortedListModel());
            this.m_selectedList.addListSelectionListener(this);
            this.m_selectedList.addMouseListener(new VWMouseAdapter(this));
            this.m_selectedList.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_selectedList.addFocusListener(this);
            sListPanel.add((Component)new JScrollPane(this.m_selectedList), gbCons);
            VWAccessibilityHelper.setLabelFor(this.m_selectedLabel, this.m_selectedList);
            VWAccessibilityHelper.setAccessibility(this.m_selectedList, sListPanel, this.m_selectedLabel.getText(), this.m_selectedLabel.getText());
            return sListPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    protected void updateTheMainButtonsState() {
        int[] selectedIndices = this.m_selectedList.getSelectedIndices();
        if (this.m_modeButton != null) {
            this.m_modeButton.setEnabled(selectedIndices.length > 0);
            this.m_modeButton.setFocusable(this.m_modeButton.isEnabled());
        }
        super.updateTheMainButtonsState();
    }

    protected void onAddItemsAction(Object[] items) {
        try {
            if (items != null) {
                ArrayList<VWCaseParameterInfo> selectedList = this.m_selectedPropertyMap.get(this.m_selectedFieldDefinition.getName());
                for (int i = 0; i < items.length; ++i) {
                    VWCaseParameterInfo paramInfo = (VWCaseParameterInfo)items[i];
                    VWParameterDefinition paramDef = paramInfo.getParameterDefinition();
                    if (paramDef != null) {
                        paramInfo.setMode(paramDef.getMode());
                    } else if (paramInfo.getMode() == -1) {
                        paramInfo.setMode(1);
                    }
                    if (paramDef != null && this.m_deletedStepParameters.contains(paramDef)) {
                        this.m_deletedStepParameters.remove(paramDef);
                    }
                    if (selectedList == null) continue;
                    selectedList.add(paramInfo);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(JOptionPane.getFrameForComponent(this.m_parentContainer), ex.getLocalizedMessage(), 1);
        }
    }

    protected Object[] onRemoveItemsAction(Object[] items) {
        try {
            if (items != null) {
                ArrayList<VWCaseParameterInfo> selectedList = this.m_selectedPropertyMap.get(this.m_selectedFieldDefinition.getName());
                for (int i = 0; i < items.length; ++i) {
                    VWCaseParameterInfo paramInfo = (VWCaseParameterInfo)items[i];
                    paramInfo.setMode(-1);
                    VWParameterDefinition paramDef = paramInfo.getParameterDefinition();
                    if (paramDef != null && !this.m_deletedStepParameters.contains(paramDef)) {
                        this.m_deletedStepParameters.add(paramDef);
                    }
                    if (selectedList == null) continue;
                    selectedList.remove(paramInfo);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(JOptionPane.getFrameForComponent(this.m_parentContainer), ex.getLocalizedMessage(), 1);
        }
        return super.onRemoveItemsAction(items);
    }

    public void removeReferences() {
        this.m_vwSession = null;
        if (this.m_guidFieldsCombo != null) {
            this.m_guidFieldsCombo.removeActionListener(this);
            this.m_guidFieldsCombo = null;
        }
        if (this.m_modeButton != null) {
            this.m_modeButton.removeActionListener(this);
            this.m_modeButton = null;
        }
        super.removeReferences();
    }

    private DefaultComboBoxModel getComboBoxModel() {
        DefaultComboBoxModel<VWFieldDefinition> comboBoxModel = new DefaultComboBoxModel<VWFieldDefinition>();
        try {
            String[] guidFieldNames = VWCaseParameterInfo.getGuidFieldNames(this.m_authPropertyData);
            if (guidFieldNames != null) {
                for (int i = 0; i < guidFieldNames.length; ++i) {
                    VWFieldDefinition fieldDef = this.m_authPropertyData.getField(guidFieldNames[i]);
                    if (fieldDef == null) continue;
                    comboBoxModel.addElement(fieldDef);
                }
                VWParameterDefinition[] parameterDefs = this.m_stepDefinition.getParameterDefinitions();
                this.m_selectedPropertyMap = VWCaseParameterInfo.getSelectedProperties(guidFieldNames, parameterDefs);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return comboBoxModel;
    }

    private void updateMode(int newMode) throws VWException {
        Object[] selectedItems = this.m_selectedList.getSelectedValues();
        if (selectedItems != null) {
            for (int i = 0; i < selectedItems.length; ++i) {
                ((VWCaseParameterInfo)selectedItems[i]).setMode(newMode);
            }
            this.m_selectedList.repaint();
        }
    }

    private void displayModePopup(Component component, int x, int y) {
        if (this.m_modePopupMenu == null) {
            this.m_modePopupMenu = new VWPopupMenu();
            this.m_modePopupMenu.removeAll();
            this.m_readModeMenuItem = new JMenuItem(VWResource.s_read);
            this.m_readModeMenuItem.addActionListener(this);
            this.m_modePopupMenu.add(this.m_readModeMenuItem);
            this.m_readWriteModeMenuItem = new JMenuItem(VWResource.s_readWrite);
            this.m_readWriteModeMenuItem.addActionListener(this);
            this.m_modePopupMenu.add(this.m_readWriteModeMenuItem);
            this.m_writeModeMenuItem = new JMenuItem(VWResource.s_write);
            this.m_writeModeMenuItem.addActionListener(this);
            this.m_modePopupMenu.add(this.m_writeModeMenuItem);
        }
        this.m_modePopupMenu.applyComponentOrientation(this.getComponentOrientation());
        this.m_modePopupMenu.show(component, x, y);
    }
}

